#ifndef READERTOOL_H
#define READERTOOL_H

#include <QMainWindow>
#include <ui_ReaderTool.h>

#include <QrfeTraceModule>

class JobCenter;

class TraceWindowManager;
class ErrorTraceManager;

class Application;

class QrfeReaderManager;
class ReaderControll;
class FirmwareUpdateManager;

class TagTreeControl;
class InformationTableController;
class GuiController;
class ExportController;
class TimeTrackController;
class ToolController;

class TagReadBeep;


class ReaderTool : public QMainWindow, QrfeTraceModule
{
    Q_OBJECT

public:
    ReaderTool(QWidget *parent = 0);
    ~ReaderTool();

    bool init ( QStringList arguments );

public slots:
	virtual void	setVisible ( bool visible );

private slots:
    void helpRequested();
    void helpRequestedUSB();

    void permissionsChanged();
    void customToolsChanged();
    void demosChanged();

protected:
    void dragEnterEvent(QDragEnterEvent *event);
    void dragMoveEvent(QDragMoveEvent *event);
    void dragLeaveEvent(QDragLeaveEvent *event);
    void dropEvent(QDropEvent *event);

private:
    void processArguments ( const QStringList & args );
    void prepareHelpMenu ( );
    void showSplashMessage ( const QString & message );


signals:
	void showSplashMessage ( const QString & message, int alignment, const QColor & color );

private:
    Ui::ReaderToolClass ui;
    QAction*			m_actionHelp;
    QAction*			m_actionHelpUSB;

    JobCenter*					m_jobCenter;

    Application*				m_application;

    ErrorTraceManager*			m_errorTraceManager;
    TraceWindowManager*			m_traceWindowManager;

    QrfeReaderManager* 			m_manager;
    ReaderControll* 			m_readerController;
    FirmwareUpdateManager*				m_updateManager;

    TagTreeControl* 			m_tagTreeControl;
    InformationTableController* m_informationTableController;
    GuiController* 				m_guiController;
    ExportController*			m_exportController;
    TimeTrackController* 		m_timeTrackController;
    ToolController* 			m_toolController;

    TagReadBeep*				m_tagReadBeep;
};

#endif // READERTOOL_H
